/*
 * Decompiled with CFR 0.152.
 */
package org.codefilarete.stalactite.engine.runtime;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.codefilarete.stalactite.engine.cascade.AfterInsertCollectionCascader;
import org.codefilarete.stalactite.engine.runtime.AssociationRecord;
import org.codefilarete.stalactite.engine.runtime.AssociationRecordPersister;
import org.codefilarete.stalactite.mapping.EntityMapping;
import org.codefilarete.tool.collection.Iterables;

public class AssociationRecordInsertionCascader<SRC, TRGT, SRCID, TRGTID, C extends Collection<TRGT>>
extends AfterInsertCollectionCascader<SRC, AssociationRecord> {
    private final Function<SRC, C> collectionGetter;
    private final EntityMapping<SRC, SRCID, ?> mappingStrategy;
    private final EntityMapping<TRGT, TRGTID, ?> targetStrategy;

    public AssociationRecordInsertionCascader(AssociationRecordPersister<AssociationRecord, ?> persister, Function<SRC, C> collectionGetter, EntityMapping<SRC, SRCID, ?> mappingStrategy, EntityMapping<TRGT, TRGTID, ?> targetStrategy) {
        super(persister);
        this.collectionGetter = collectionGetter;
        this.mappingStrategy = mappingStrategy;
        this.targetStrategy = targetStrategy;
    }

    @Override
    protected void postTargetInsert(Iterable<? extends AssociationRecord> entities) {
    }

    @Override
    protected Collection<AssociationRecord> getTargets(SRC src) {
        Collection targets = (Collection)this.collectionGetter.apply(src);
        return Iterables.stream((Iterable)targets).map(target -> new AssociationRecord(this.mappingStrategy.getId(src), this.targetStrategy.getId(target))).collect(Collectors.toList());
    }
}

